//Experiment-7      
//windows 8.1 - 64-Bit
//Scilab - 6.0.0

//Aim : Design of an iron cored choke coil using SCILAB coding
////Data: Design a single phase variable choke coil

clc
clear

//Following data are to be taken from user 

V=input('Enter value of supply voltage') // supply voltage (in the range of 230 - 440 V)
f=input('Enter frequency of supply') // supply frequency = 50 Hz in India and 60 Hz in US
I=input('Enter value of current to be carried in Amp') // currentn carrying capacity in Amp ( in the range of 5 - 25 Amp)
lg=input('Enter maximum airgap length in cms') // airgap length varies between 0 and 10 cms being variable choke coil

//Actual Calculations begin

uo=4*%pi*1e-7 // permeability of free space
Sf=0.9 // stacking factor
K=(uo*V*I)/(2*%pi*f*2*lg/100)
i=1
for Bg=0.2:0.1:0.8 
   A_root(i)=sqrt(K)/Bg
   i=i+1
end 
Bgm=0.45
A_root=0.0225
A_i=A_root^2 // net iron area
Agi=A_i/Sf; // gross iron area
A  = sqrt(Agi) // width of limb
ATg = Bgm*2*lg/100/uo // airgap mmf
ATt = 1.1*ATg // total mmf
N  = ceil(ATt / I) // no. of turns
del=2.4 // current density
a  = I/del // conductor area in mm^2
d  = sqrt(4*a/%pi)+.05 // diameter of conductor in mm
d1 = 2.488 // diameter of insulated conductor
a1 = (%pi/4)*d1^2 // cross sectional area of insulated conductor
sf = 0.8*(d/d1)^2 // space factor
Aw = N*a1/sf // area of window
AW = 1.2*Aw // gross window area in mm^2
Ww = sqrt(AW/2) // width of window in mm
Hw = 2*Ww // height of window assuming H/W ratio is 2
hf = Hw-20 // height of winding
Nh = ceil(hf/d1) // no. of conductors in height
Nd = N/(2*Nh) // no. of conductors in depth
dc = ceil(Nd*d1) // depth of coil
dc1 = dc+5 // actual depth of coil
hf1 = ceil(hf+10) // actual height of winding
dw = ceil(Ww - 2*dc1) // distance betwen two coils
D = ceil(Ww + A*1000) // distance between limbs
WC = ceil(D+A*1000) // width of core in mm
HC = ceil(Hw+2*A*1000+lg*10) // height of core in mm
Z= V/I
mprintf('Diameter of insulated conductor is %f mm', d1)
mprintf('\n')
mprintf('Area of insulated conductor is %f mm^2', a1)
mprintf('\n')
mprintf('Height of coil is %d mm',hf1)
mprintf('\n')
mprintf('Depth of coil is %d mm',dc1)
mprintf('\n')
mprintf('Height of core is %d mm',HC)
mprintf('\n')
mprintf('Width of core is %d mm',WC)
mprintf('\n')
mprintf('Impedance of the coil is %d Ohms',Z)



